# Polygons
import pygame
import math

def distance (a, b):
    d = (a[0]-b[0])*(a[0]-b[0]) + (a[1]-b[1])*(a[1]-b[1])
    return math.sqrt(d)

def regular_polygon (xc, yc, r, n):
    pi = 3.1415926
    pi2 = pi/2
    x0 = xc + r
    y0 = yc
    verts = []
    a = 2*pi/n
    for i in range(0,n):
        x0 = xc + math.cos(pi2+a*i) * r
        y0 = yc + math.sin(pi2+a*i) * r
        verts.append([x0,y0])
    pygame.draw.polygon(screen, (0,0,0), verts, 2)

def hex (r):
    h = 2*r
    w = math.sqrt(3.0)*r
    x = w
    y = h
    for i in range(0,5,2):  # vertical
        y = 3*h/4 * (i+1)
        for j in range(0,10):
            regular_polygon (j*w, y, r, 6)
        y = 3*h/4 * (i+2)
        for j in range (0,10):
            regular_polygon (w/2+j*w, y, r, 6)

def ell (cx, cy, w, h, a1, a2):
    t = a1
    x0 = cx + w/2* math.cos(-t)
    y0 = cy + h/2* math.sin(-t)
    while t < a2:
#    for t in range(a1, a2):
        print(x0, y0)
        t = t + 0.01
        x1 = cx + w/2 * math.cos(-t)
        y1 = cy + h/2 * math.sin(-t)
        pygame.draw.line(screen, (100, 0, 0), (x0,y0), (x1,y1), 2)
        x0 = x1
        y0 = y1



width = 600
height = 600
screen = pygame.display.set_mode((width, height))
clock = pygame.time.Clock()
pygame.init()
FPS = 10
a1 = math.radians(-60)
while True:
    clock.tick(FPS)
    mouseX, mouseY = pygame.mouse.get_pos()
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            quit()

    screen.fill((255, 255, 255))
    regular_polygon (100, 100, 40, 3)
    regular_polygon (100, 200, 50, 5)
    regular_polygon (100, 325, 50, 7)
    regular_polygon (100, 450, 50, 9)
    pygame.display.update()
